/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2004          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */

static char *sccsid = "@(#)46   1.3   src/rsct/pgs/samples/Sample_FrameTable.C, gssamples, rsct_rzauh, rzauh0431a 5/14/01 09:43:24";

#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif

/*********************************************************************/
/*
 * Name:  Sample_FrameTable.C
 *
 * Used to build a table of frame/node pairs for displaying the list
 * of providers in a group.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_FrameTable.h"
#include "Sample_Frame.h"                    // Define the frame objects.

FrameTable::FrameTable(void)
{
    count = 0;
    highestFrameNumber = highestProvCount = -1;

    for (int i = 0; i <= MAX_FRAMES; i++) {
        frameTable[i] = NULL;
        frameProvCount[i] = 0;
    }

    return;
}

FrameTable::~FrameTable(void)
{
    if (-1 == highestFrameNumber) return;

    for (int i = 0; i <= highestFrameNumber; i++) {
        delete frameTable[i];
    }

    return;
}

/*********************************************************************/
/*
 * Add a provider into the correct frame.  Return number of providers
 * in table.  Need to calculate frame/node pair based on node number.
 */
/*********************************************************************/

int     FrameTable::Add(short _instance,
                        short _node,
                        unsigned int *_IPaddr,
                        ha_gs_adapter_death_t *_death)
{
    int   _frame, _slot;

    GetFrameNumber(_node, &_frame, &_slot);

    if (NULL == frameTable[_frame]) {
        frameTable[_frame] = new Frame(_frame, _slot, _instance, _IPaddr, _death);
        frameProvCount[_frame] = 1;
    } else {
        frameProvCount[_frame] = frameTable[_frame]->Add(_instance, _slot, _IPaddr, _death);
    }
    
    if (frameProvCount[_frame] > highestProvCount) highestProvCount = frameProvCount[_frame];
    if (_frame > highestFrameNumber) highestFrameNumber = _frame;

    return(++count);
}

/*********************************************************************/
/*
 * Want to do some fancy printing, a table of frames and the set of
 * providers on each node.  Use blank slots if a node is provider-less.
 * Print nothing for frames that are provider-less.
 */
/*********************************************************************/

void    FrameTable::Print(void)
{
    if (0 == count) return;             // Nothing to bother with.

    cout << "                          Nodes and Provider Instances" << endl;
    cout << "Frame    1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16" << endl;

    for (int i = 0; i <= highestFrameNumber; i++) {
        if (NULL != frameTable[i]) {
            frameTable[i]->Print();
        }
    }
    cout.flush();

    return;
}

/*********************************************************************/
/*
 * Use node number to calculate frame/slot numbers.
 */
/*********************************************************************/
    
void    FrameTable::GetFrameNumber(short    _node,
                                   int     *_frame,
                                   int     *_slot)
{
    if (0 == _node) {
        *_frame = 0;
        *_slot = 1;
        return;
    }

    *_frame = (_node / 16) + 1;
    *_slot = _node % 16;
    if (*_slot == 0) {
        (*_frame)--;
        *_slot = 16;
    }

    return;
}

